// backend/test-email.js
import 'dotenv/config';
import EmailService from './src/services/emailService.js';

async function testEmail() {
  console.log('🧪 Testing Email Service...\n');
  
  try {
    // Initialize email service
    console.log('1️⃣ Initializing email service...');
    const connected = await EmailService.initialize();
    
    if (!connected) {
      console.error('❌ Email service failed to connect');
      console.log('\n📋 Checklist:');
      console.log('   ✓ EMAIL_USER set in .env?');
      console.log('   ✓ EMAIL_PASSWORD set in .env?');
      console.log('   ✓ Using Gmail App Password (16 chars)?');
      console.log('   ✓ 2FA enabled on Gmail account?');
      return;
    }
    
    console.log('✅ Email service connected\n');
    
    // Test blog notification
    console.log('2️⃣ Sending test blog notification...');
    const testBlogData = {
      title: 'Smart Homes in Kenya: A Comprehensive Guide',
      excerpt: 'Discover how smart home technology is transforming Kenya\'s real estate market. From energy management to security systems, learn about the latest innovations making homes more efficient and sustainable.',
      link: 'https://tlchomes.co.ke/blog/smart-homes-kenya',
      imageUrl: 'https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800',
      author: 'TLC Homes Team',
      publishedDate: new Date().toLocaleDateString('en-US', { 
        year: 'numeric', 
        month: 'long', 
        day: 'numeric' 
      }),
      category: 'Smart Technology',
      tags: ['Smart Homes', 'Real Estate', 'Kenya', 'Technology']
    };
    
    // Add a test subscriber to your subscribers.json first, or use this:
    const result = await EmailService.sendBlogNotification(testBlogData);
    
    console.log('\n📊 Results:');
    console.log(`   ✅ Sent: ${result.sent}`);
    console.log(`   ❌ Failed: ${result.failed}`);
    console.log(`   📧 Total subscribers: ${result.total}`);
    
    if (result.sent > 0) {
      console.log('\n✅ Test successful! Check your inbox.');
    } else {
      console.log('\n⚠️  No emails sent. Add test subscribers to data/subscribers.json');
    }
    
  } catch (error) {
    console.error('❌ Test failed:', error.message);
    console.error('\nFull error:', error);
  }
}

// Run the test
testEmail();