// src/data/articles.js

const articlesData = {
  "articles": [
    {
      // Core Identifiers
      "post_id": 1,
      "slug": "kenya-real-estate-development-and-investment-2025",
      "status": "published",
      "url": "https://tlchomes.co.ke/blog/kenya-real-estate-development-and-investment-2025",

      // Content
      "title": "Kenya Real Estate Development and Investment: Strategic Market Analysis 2025",
      "excerpt": "Kenya's real estate market is evolving into one of Africa's most attractive investment frontiers, driven by rapid urbanization, government incentives, and sustainable development trends. Explore how Kenya's property sector is unlocking new opportunities for growth, innovation, and long-term value creation in 2025 and beyond.",
      "content": "<h2>Executive Summary</h2><p>Kenya's real estate sector represents one of the most dynamic investment opportunities in East Africa...</p>",
      "fullPageComponent": "KenyaRealEstateArticle",

      // Taxonomy
      "category_id": 1,
      "category": "Investment",
      "tags": ["real estate", "investment", "market analysis", "Kenya", "Vision 2030", "property development"],

      // Author Information
      "author_id": 2,
      "author": {
        "name": "TLC Homes Research",
        "role": "Research Team",
        "bio": "Dedicated research team providing data-driven insights into Kenya's real estate and economic landscape.",
        "avatar": "https://ui-avatars.com/api/?name=TLC+Research&background=d0c82a&color=000",
        "social": {},
        "image": "/assets/images/executives/4.jpg",
      },

      // Dates
      "publish_date": "2025-10-01T10:00:00Z",
      "last_modified_date": "2025-09-17T10:00:00Z",

      // Media
      "featured_image_url": "/assets/images/blogs/risk-protection-eliminating-risk-top-view.jpg",
      "thumbnail_image_url": "/assets/images/blogs/Types-of-real-estate-investment.jpg",


      // SEO Meta Tags
      "seo": {
        "meta_title": "Kenya Real Estate Development & Investment 2025 | TLC Homes",
        "meta_description": "Explore Kenya's real estate market with TLC Homes Services. KSh 705 billion market by 2029, 4.7% GDP growth, and 8-10% Nairobi rental yields offer compelling investment opportunities.",
        "meta_keywords": "Kenya real estate, property investment, market analysis, TLC Homes, Nairobi real estate, rental yields Kenya, real estate development Kenya, property market trends, investment opportunities Kenya, Vision 2030, sustainable development",
        "canonical_url": "https://tlchomes.co.ke/blog/kenya-real-estate-development-and-investment-2025",
        "robots": "index, follow",
        "og_title": "Kenya Real Estate Development and Investment: Strategic Market Analysis 2025",
        "og_description": "A comprehensive strategic analysis of Kenya's evolving real estate market landscape, highlighting opportunities worth KSh 705 billion by 2029.",
        "og_image": "https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=1200&h=600&fit=crop",
        "og_url": "https://tlchomes.co.ke/blog/kenya-real-estate-development-and-investment-2025",
        "og_type": "article",
        "twitter_card": "summary_large_image",
        "twitter_title": "Kenya Real Estate Development and Investment: Strategic Market Analysis 2025",
        "twitter_description": "A comprehensive strategic analysis of Kenya's evolving real estate market landscape, highlighting opportunities worth KSh 705 billion by 2029.",
        "twitter_image": "https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=1200&h=600&fit=crop"
      },

      // Display Settings
      "read_time": "15 min read",
      "featured": true,
      "featured_order": 2,

      // Analytics
      "views": 1847,
      "likes": 142,

      // Additional Features
      "has_audio": false,
      "audio_url": null
    },
    {
      // Core Identifiers
      "post_id": 2,
      "slug": "smarter-modern-way-revitalizing-urban-rental-spaces",
      "status": "published",
      "url": "https://tlchomes.co.ke/blog/smarter-modern-way-revitalizing-urban-rental-spaces",

      // Content
      "title": "The Smarter Modern Way of Revitalizing Urban Rental Spaces",
      "excerpt": "Kenya's smart home market is revolutionizing urban living with a projected 8.2% annual growth through 2028. Discover how integrated IoT devices, AI-powered security, solar energy systems, and community-centered design are transforming rental properties into high-performance assets that deliver 33% energy savings, 15-20% property value increases, and create sustainable, connected neighborhoods across Nairobi and beyond.",
      "content": "<h2>The Smart Home Revolution</h2><p>Kenya's urban rental landscape is being transformed by smart home technologies that deliver measurable returns...</p>",
      "fullPageComponent": "SmartHomesArticle",

      // Taxonomy
      "category_id": 2,
      "category": "Smart Homes",
      "tags": [
        "smart homes",
        "smart home equipment",
        "smart home integration",
        "property investment",
      ],

      // Author Information
      "author_id": 3,
      "author": {
        "name": "TLC Innovation Team",
        "role": "Technology Division",
        "bio": "Pioneering smart home and sustainable technologies for modern living and community development across Kenya.",
        "avatar": "https://ui-avatars.com/api/?name=Innovation+Team&background=d0c82a&color=000",
        "social": {
          "linkedin": "https://linkedin.com/company/tlc-homes-kenya",
          "twitter": "https://twitter.com/tlchomeskenya"
        }
      },

      // Dates
      "publish_date": "2025-11-01T10:00:00Z",
      "last_modified_date": "2025-11-04T10:00:00Z",

      // Media
      "featured_image_url": 'https://img.freepik.com/free-photo/medium-shot-woman-kids-spending-time-home_23-2150639954.jpg',
      "thumbnail_image_url": 'https://img.freepik.com/free-photo/medium-shot-woman-kids-spending-time-home_23-2150639954.jpg',

      // SEO Meta Tags - Fully Optimized
      "seo": {
        "meta_title": "Smart Homes Kenya 2025: Transform Rental Properties with IoT Technology | TLC Homes",
        "meta_description": "Revolutionize your Kenyan rental properties with smart home technology. Achieve 33% energy savings, 18-25% ROI, and 15-20% property value increase through IoT devices, AI security, solar integration, and community-centered design. Complete guide by TLC Homes.",
        "meta_keywords": "smart homes Kenya, smart home technology Kenya, IoT devices Kenya, home automation Kenya, smart security systems Kenya, biometric locks, AI cameras, smart thermostats, solar panels Kenya, energy efficiency, smart water meters, automated irrigation, smart lighting, leak detectors, property technology, rental property upgrades Kenya, sustainable homes, green building Kenya, smart home installation, TLC Homes Kenya, Nairobi smart homes, urban rental spaces, property investment Kenya, tenant retention, remote monitoring, voice assistants Kenya, air quality monitors, Vision 2030, climate resilience Kenya, community living, Kilimani apartments, Westlands properties, satellite towns Kenya, Ruiru, Athi River, Kahawa Sukari, smart inverters, renewable energy Kenya, property ROI, rental yields Kenya, middle-income housing, affordable housing Kenya, smart property management, 5kW solar inverters, EDGE certification, LEED Kenya, National Green Growth Strategy, Gen Z renters, millennials housing, blackout-proof homes, motion sensors, WiFi-enabled devices, smartphone home control",
        "canonical_url": "https://tlchomes.co.ke/blog/smarter-modern-way-revitalizing-urban-rental-spaces",
        "robots": "index, follow",

        // Open Graph
        "og_title": "Smart Homes Kenya: Transform Rentals with IoT & Achieve 18-25% ROI",
        "og_description": "Complete guide to smart home technology in Kenya. Learn how IoT devices, AI security, solar integration, and community-centered design deliver 33% energy savings, 15-20% property value increases, and superior tenant retention. Expert insights from TLC Homes.",
        "og_image": 'https://img.freepik.com/free-photo/medium-shot-woman-kids-spending-time-home_23-2150639954.jpg',
        "og_url": "https://tlchomes.co.ke/blog/smarter-modern-way-revitalizing-urban-rental-spaces",
        "og_type": "article",

        // Twitter Card
        "twitter_card": "summary_large_image",
        "twitter_title": "Smart Homes Kenya 2025: IoT Technology for Rental Properties | TLC Homes",
        "twitter_description": "Transform your rental properties with smart home technology. Achieve 33% energy savings, 18-25% ROI through IoT devices, security systems, and sustainable design. Complete implementation guide.",
        "twitter_image": 'https://img.freepik.com/free-photo/medium-shot-woman-kids-spending-time-home_23-2150639954.jpg'
      },

      // Display Settings
      "read_time": "12 min read",
      "featured": true,
      "featured_order": 1,

      // Analytics
      "views": 234,
      "likes": 45,

      // Additional Features
      "has_audio": false,
      "audio_url": null
    },
    {
      "post_id": 3,
      "slug": "land-as-legacy-pioneering-east-africas-future",
      "status": "published",
      "url": "https://tlchomes.co.ke/blog/land-as-legacy-pioneering-east-africas-future",

      "title": "Land As Legacy: Pioneering East Africa's Future",
      "excerpt": "In the heart of Kenya, where the earth pulses with untapped potential, land emerges as more than soil, it is a legacy waiting to be shaped. Discover how TLC Homes is redefining land investment through precision agrotech, data-centered wellness real estate, and holistic community development that transforms acres into ecosystems of sustainable prosperity across East Africa.",
      "content": "<h2>Land as Legacy</h2><p>In the heart of Kenya, where the earth pulses with untapped potential, I see land not just as soil beneath our feet but as a legacy waiting to be shaped...</p>",
      "fullPageComponent": "LandAsLegacyArticle",

      "category_id": 9,
      "category": "Impact & Innovation",
      "tags": [
        "land investment",
        "legacy building",
        "precision agrotech",
        "wellness real estate",
        "sustainable development",
        "East Africa",
        "Kenya Vision 2030",
        "AI agriculture",
        "smart communities",
        "data-driven development",
        "holistic investment",
        "climate resilience",
        "food security",
        "urban innovation",
        "community wellbeing"
      ],

      "author_id": 1,
      "author": {
        "name": "Mr. Solomon Rimui",
        "role": "Founder & CEO",
        "bio": "Visionary leader with a people-first approach, transforming lives through integrity, sustainability, and innovation.",
        "avatar": "https://ui-avatars.com/api/?name=Solomon+Rimui&background=d0c82a&color=000",
        "social": {
          "linkedin": "https://linkedin.com/in/solomon-rimui",
          "twitter": "https://twitter.com/tlchomeskenya"
        }
      },

      "publish_date": "2025-12-08T10:00:00Z",
      "last_modified_date": "2025-12-08T10:00:00Z",

      "featured_image_url": "https://i9sg3m887v.ufs.sh/f/5Ej9CA3xozqj14k9LY0H6xT9SUm8NRZlGnWzdBawgKibCshO",
      "thumbnail_image_url": "https://i9sg3m887v.ufs.sh/f/5Ej9CA3xozqjDO8prBv6TZwqo2kS4RmtdcHp0aQfzM3VxBK7",

      "seo": {
        "meta_title": "Land As Legacy: Pioneering East Africa's Future with Precision Agrotech & Wellness Real Estate | TLC Homes",
        "meta_description": "Discover how TLC Homes transforms land into legacy through precision agrotech, AI-powered agriculture, data-centered wellness real estate, and sustainable community development. From CEO Solomon Rimui, a vision for Kenya and East Africa's sustainable prosperity through holistic land investment and innovation.",
        "meta_keywords": "land as legacy, land investment Kenya, precision agrotech, AI agriculture Kenya, wellness real estate, sustainable development East Africa, data-driven land development, smart communities Kenya, holistic investment approach, climate-resilient farming, food security Kenya, urban innovation Africa, community wellbeing, TLC Homes Kenya, Solomon Rimui, Kenya Vision 2030, soil health optimization, green energy systems, self-healing infrastructure, investor portals, real-time land insights, sustainable technology, East Africa renaissance, economic resilience, cross-industry collaboration, future-ready development, Kenya urbanization, supply chain integration, digital literacy, community apps, environmental sustainability, responsible technology, legacy building, transformative investment",
        "canonical_url": "https://tlchomes.co.ke/blog/land-as-legacy-pioneering-east-africas-future",
        "robots": "index, follow",

        "og_title": "Land As Legacy: Pioneering East Africa's Future Through Innovation",
        "og_description": "CEO Solomon Rimui's manifesto on transforming land into legacy. Discover how TLC Homes integrates precision agrotech, wellness real estate, and AI-driven sustainability to create thriving communities and sustainable prosperity across Kenya and East Africa.",
        "og_image": "https://i9sg3m887v.ufs.sh/f/5Ej9CA3xozqj14k9LY0H6xT9SUm8NRZlGnWzdBawgKibCshO",
        "og_url": "https://tlchomes.co.ke/blog/land-as-legacy-pioneering-east-africas-future",
        "og_type": "article",

        "twitter_card": "summary_large_image",
        "twitter_title": "Land As Legacy: Pioneering East Africa's Future | TLC Homes Founder's Vision",
        "twitter_description": "From soil to legacy: How precision agrotech, wellness real estate, and holistic innovation are transforming Kenya's land into sustainable prosperity. A manifesto by Solomon Rimui, CEO of TLC Homes.",
        "twitter_image": "https://i9sg3m887v.ufs.sh/f/5Ej9CA3xozqj14k9LY0H6xT9SUm8NRZlGnWzdBawgKibCshO"
      },

      "read_time": "18 min read",
      "featured": true,
      "featured_order": 3,

      "views": 0,
      "likes": 0,

      "has_audio": false,
      "audio_url": null
    }
  ],

  "categories": [
    {
      "category_id": 1,
      "name": "Investment",
      "slug": "investment",
      "description": "Market analysis, investment opportunities, and financial insights for Kenya's real estate and business sectors.",
      "color": "#d0c82a"
    },
    {
      "category_id": 2,
      "name": "Smart Homes",
      "slug": "smart-homes",
      "description": "Technology integration, energy efficiency, and modern home automation solutions.",
      "color": "#d0c82a"
    },
    {
      "category_id": 3,
      "name": "Real Estate",
      "slug": "real-estate",
      "description": "Property development, market trends, and housing solutions across Kenya.",
      "color": "#e76f51"
    },
    {
      "category_id": 4,
      "name": "Agriculture",
      "slug": "agriculture",
      "description": "Agribusiness insights, farming innovations, and rural development strategies.",
      "color": "#6a994e"
    },
    {
      "category_id": 5,
      "name": "Interior Design",
      "slug": "interior-design",
      "description": "Design trends, home decor, and creating beautiful, functional living spaces.",
      "color": "#bc4b51"
    },
    {
      "category_id": 6,
      "name": "Supply and Procurement",
      "slug": "supply-and-procurement",
      "description": "Supply chain optimization, procurement strategies, and logistics innovations.",
      "color": "#457b9d"
    },
    {
      "category_id": 7,
      "name": "Sustainability",
      "slug": "sustainability",
      "description": "Environmental impact, green technologies, and sustainable business practices.",
      "color": "#588157"
    },
    {
      "category_id": 8,
      "name": "Leadership",
      "slug": "leadership",
      "description": "Management insights, company culture, and people-first business strategies.",
      "color": "#f4a261"
    },
    {
      "category_id": 9,
      "name": "Impact & Innovation",
      "slug": "impact-innovation",
      "description": "Social impact, technological innovations, and transformative business models.",
      "color": "#264653"
    }
  ],

  "authors": [
    {
      "author_id": 1,
      "name": "Mr. Solomon Rimui",
      "role": "Founder & CEO",
      "bio": "Visionary leader with a people-first approach, transforming lives through integrity, sustainability, and innovation.",
      "avatar": "https://ui-avatars.com/api/?name=Solomon+Rimui&background=d0c82a&color=000",
      "social": {
        "linkedin": "https://linkedin.com/in/solomon-rimui",
        "twitter": "https://twitter.com/tlchomeskenya"
      }
    },
    {
      "author_id": 2,
      "name": "TLC Homes Research",
      "role": "Research Team",
      "bio": "Dedicated research team providing data-driven insights into Kenya's real estate and economic landscape.",
      "avatar": "https://ui-avatars.com/api/?name=TLC+Research&background=d0c82a&color=000",
      "social": {}
    },
    {
      "author_id": 3,
      "name": "TLC Innovation Team",
      "role": "Technology Division",
      "bio": "Pioneering smart home and sustainable technologies for modern living and community development across Kenya.",
      "avatar": "https://ui-avatars.com/api/?name=Innovation+Team&background=d0c82a&color=000",
      "social": {
        "linkedin": "https://linkedin.com/company/tlc-homes-kenya",
        "twitter": "https://twitter.com/tlchomeskenya"
      }
    },
    {
      "author_id": 4,
      "name": "TLC Design Studio",
      "role": "Interior Design Team",
      "bio": "Creating beautiful, functional spaces that blend Kenyan heritage with contemporary design.",
      "avatar": "https://ui-avatars.com/api/?name=Design+Studio&background=d0c82a&color=000",
      "social": {}
    },
    {
      "author_id": 5,
      "name": "TLC Supply Chain Team",
      "role": "Logistics Division",
      "bio": "Optimizing supply chains and procurement processes to drive efficiency and value.",
      "avatar": "https://ui-avatars.com/api/?name=Supply+Team&background=d0c82a&color=000",
      "social": {}
    }
  ]

};

export default articlesData;